﻿local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

AL:RegisterTranslations("deDE", function() return {
    --Text strings for UI objects
    ["AtlasLoot"] = "AtlasLoot",
    ["No match found for"] = "Kein Eintrag gefunden für",
    ["Search"] = "Suchen",
    ["Clear"] = "Löschen",
    ["Select Loot Table"] = "Wähle Loot Rubrik",
    ["Select Sub-Table"] = "Wähle Unter-Rubrik",
    ["Drop Rate: "] = "Droprate",
    ["DKP"] = "DKP",
    ["Priority:"] = "Priorität:",
    ["Click boss name to view loot."] = "Klicke Boss um den Loot zu sehen.",
    ["Various Locations"] = "Verschiedene Orte",
    ["This is a loot browser only.  To view maps as well, install either Atlas or Alphamap."] = "Atlasloot zeigt nur Loot an. Falls du Karten möchtest, installiere bitte 'Atlas' oder 'Alphamap'.",
    ["Toggle AL Panel"] = "AL-Leiste ein/aus",
    [" is safe."] = " ist sicher.",
    ["Server queried for "] = "Fragt den Server nach ",
    [".  Right click on any other item to refresh the loot page."] = ".  Rechtsklicke auf ein beliebiges anderes Item um den Loot auf der Seite zu aktualisieren.",
    ["Back"] = "Zurück",
    ["Level 60"] = "Level 60",
    ["Level 70"] = "Level 70",
    ["|cffff0000(unsafe)"] = " |cffff0000(unsicher)",
    ["Misc"] = "Sonstiges",
    ["Rewards"] = "Belohnungen",
    ["Heroic Mode"] = "Heroisch",
    ["Normal Mode"] = "Normal",
    ["Raid"] = "Raid",
    ["Factions - Azeroth"] = "Fraktionen - Azeroth",
    ["Factions - Outland"] = "Fraktionen - Scherbenwelt",
    ["Factions - Shattrath City"] = "Fraktionen - Shattrath",
    ["Pre-Burning Crusade"] = "Vor Burning Crusade",
    ["Post-Burning Crusade"] = "Nach Burning Crusade",
    ["Choose Table ..."] = "Wähle Tabelle ...",
    ["Close Menu"] = "Schließe Menü",
    ["Unknown"] = "Unknown",
    ["Skill Required:"] = "Benötigt Fertigkeit:",
    --- ["QuickLook"] = true,
    ["Add to QuickLooks:"] = "Zu QuickLook hinzufügen",
    ---["Assign this loot table\n to QuickLook"] = true,
    ["Req. Rating:"] = "Wertung benötigt",
    ---["Query Server"] = true,

    --Text for Options Panel
    ["Atlasloot Options"] = "AtlasLoot Optionen",
    ["Safe Chat Links |cff1eff00(recommended)|r"] = "Sichere Chatlinks |cff1eff00(empfohlen)|r",
    ["Enable all Chat Links |cffff0000(use at own risk)|r"] = "Aktiviere alle Chatlinks |cffff0000(auf eigene Gefahr)|r",
    ["Default Tooltips"] = "Standard Tooltips",
    ["Lootlink Tooltips"] = "Lootlink Tooltips",
    ["|cff9d9d9dLootlink Tooltips|r"] = "|cff9d9d9dLootlink Tooltips|r",
    ["ItemSync Tooltips"] = "ItemSync Tooltpis",
    ["|cff9d9d9dItemSync Tooltips|r"] = "|cff9d9d9dItemSync Tooltips|r",
    ["Use EquipCompare"] = "Benutze EquipCompare",
    ["|cff9d9d9dUse EquipCompare|r"] = "|cff9d9d9dBenutze EquipCompare|r",
    ["Show Comparison Tooltips"] = "Zeige eigenes Item zum Vergleich",
    ["Make Loot Table Opaque"] = "Hintergrund undurchsichtig",
    ["Show itemIDs at all times"] = "Zeige Item-IDs immer an",
    ["Hide AtlasLoot Panel"] = "Blende die AtlasLoot-Leiste aus",
    ["Show Minimap Button"] = "Blende Button an der Minimap ein",
    ["Set Minimap Button Position"] = "Setze die Position des Buttons an der Minimap",
    ["Suppress text spam when querying items"] = "Unterdrücke Meldung bei Itemabfragen",
    ["Notify me when a LoD Module is loaded"] = "Benachrichtige mich beim Laden von Modulen",
    ["Load all loot modules at startup"] = "Lade alle Module direkt beim Start",
    ["AutoQuery items on loot tables |cffff0000(disconnection risk)|r"] = "Automatisches Abfragen von Items |cffff0000(auf eigene Gefahr)|r",
    ["Done"] = "OK",
    ["WishList"] = "Wunschzettel",
    ["Search Result: %s"] = "Suchtext",
    ["Last Result"] = "Letzte Suche",
    ["Search on"] = "Suchen in",
    ["All modules"] = "Alle Module",
    ["If checked, AtlasLoot will load and search across all the modules."] = "Falls gewählt, sucht Atlasloot in allen Modulen",
    ["Search options"] = "Suchoptionen",
    ---["Partial matching"] = true,
    ---["If checked, AtlasLoot search item names for a partial match."] = true,
    ["You don't have any module selected to search on!"] = "Du hast kein Modul zur Suche ausgewählt",
    --The next 4 lines are the tooltip for the Server Query Button
    --The translation doesn't have to be literal, just re-write the
    --sentences as you would naturally and break them up into 4 roughly
    --equal lines.
    ["Queries the server for all items"] = "Fragt den Server nach allen Items",
   	["on this page. The items will be"] = "auf dieser Seite. Die Items werden",
    ["refreshed when you next mouse"] = "geladen, sobald ihr das nächste Mal",
    ["over them."] = "mit der Maus drüber fahrt.",

    --Slash commands
	--    ["reset"] = true,
	--    ["options"] = true,
	--    ["Reset complete!"] = true,

    --Error Messages and warnings
    ["AtlasLoot Error!"] = "AtlasLoot Fehler!",
    ["WishList Full!"] = "Wunschzettel voll!",
    [" added to the WishList."] = " zum Wunschzettel hinzugefügt",
    [" already in the WishList!"] = " bereits auf dem Wunschzettel!",
    [" deleted from the WishList."] = "vom Wunschzettel gelöscht",

    --Incomplete Table Registry error message
    [" not listed in loot table registry, please report this message to the AtlasLoot forums at http://www.atlasloot.net"] = " nicht im Loot-Tabellen Register gelistet, bitte melde diese Nachricht im AtlasLoot Forum unter http://www.atlasloot.net",

    --LoD Module disabled or missing
    [" is unavailable, the following load on demand module is required: "] = " ist nicht verfügbar, das folgende Modul wird benötigt: ",

    --LoD Module load sequence could not be completed
    ["Status of the following module could not be determined: "] = "Status von folgendem Modul konnte nicht festgestellt werden: ",

    --LoD Module required has loaded, but loot table is missing
    [" could not be accessed, the following module may be out of date: "] = " konnte nicht erreicht werden, das folgende Modul könnte veraltet sein: ",

    --LoD module loaded successfully
    ["sucessfully loaded."] = "erfogreich geladen.",

    --Need a big dataset for searching
    ["Loading available tables for searching"] = "Lade verfügbare Module zum Suchen",

    --All Available modules loaded
    ["All Available Modules Loaded"] = "Alle verfügbaren Module geladen",

    --Minimap Button
    ["|cff1eff00Left-Click|r Browse Loot Tables"] = "|cff1eff00Linksklick|r Loot-Tabellen durchsuchen",
    ["|cffff0000Right-Click|r View Options"] = "|cffff0000Rechtsklick|r Optionen anzeigen",
    ["|cffff0000Shift-Click|r View Options"] = "|cffff0000Shift-Klick|r Optionen anzeigen",
    ["|cffccccccLeft-Click + Drag|r Move Minimap Button"] = "|cffccccccLinksklick + Ziehen|r Minimap-Button bewegen",

    --AtlasLoot Panel
    ["Options"] = "Optionen",
    ["Collections"] = "Sammlungen",
    ["Factions"] = "Fraktionen",
    ["World Events"] = "Welt-Events",
    ["Load Modules"] = "Module laden",
	--    ["Crafting"] = true,

    --First time user
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences."] = "Willkommen zu Atlasloot Enhanced!  Bitte nimm dir einen Moment Zeit, um die Einstellungen festzulegen",
    ["New feature in 4.02.01: Type '/atlasloot options' to bring up the options menu and '/atlasloot reset' to reset AtlasLoot after a disconnect."] = "Neues Feature in 4.02.01: Gib 'atlasloot options' ein, um das Optionen Menü anzeigen zu lassen und 'atlasloot reset' um Atlasloot nach einem Disconnect zurückzusetzen.",
    ["New feature in 4.03.00: Introducing the Wishlist!  Simply alt-click on any item to add it to the wishlist.  To delete an item from the wishlist, open up your wishlist and alt-click the item to remove it.  It's that simple.  Buttons to view the wishlist have been added to the Atlas interface and the loot browser."] = "Neues Feature in 4.03.00: Wunschzettel! Mit Alt-Klick könnt ihr jedes beliebige Item zum Wunschzettel hinzufügen. Mit Alt-Klick könnt ihr ein Item wieder vom Wunschzettel löschen. Den Wunschzettel könnt ihr über das Atlasloot Interface oder den Loot Browser öffnen." ,
    ---["New feature in 4.05.00: Advanced searching functionality is now available. You can type in a partial item name, for example typing 'elixir' gives all items in the database with 'elixir' in the name.  Big thanks to Kurax for his help."] = true,
    ---["New feature in 4.05.00: All professions are now included in the AtlasLoot_Crafting module."] = true,
    ["Welcome to Atlasloot Enhanced.  Please take a moment to set your preferences for tooltips and links in the chat window.\n\n  This options screen can be reached again at any later time by typing '/atlasloot'."] = "Willkommen zu Atlasloot Enhanced!  Bitte nimm dir einen Moment Zeit, um die Einstellungen für Tooltips und Chatlinks festzulegen.\nWenn du später etwas ändern willst, kannst du den Optionsbildschirm mit /atlasloot aufrufen.",
    ["Setup"] = "Optionen",

    --Old Atlas Detected
    ["It has been detected that your version of Atlas does not match the version that Atlasloot is tuned for ("] = "Atlasloot hat festgestellt, dass die Version von Atlas, die du benutzt, nicht der Version entspricht für die Atlasloot konzipiert ist(",
    [").  Depending on changes, there may be the occasional error, so please visit http://www.atlasmod.com as soon as possible to update."] = "). Dadurch können (schwere) Fehler auftreten! Bitte besuch so schnell wie möglich http://www.atlasmod.com und lad dir die neuste Atlas Version runter.",
    ["OK"] = "OK",
    ["Incompatible Atlas Detected"] = "Nicht kompatibles Atlas gefunden",

    --Unsafe item tooltip
    ["Unsafe Item"] = "Unsicheres Item",
    ["Item Unavailable"] = "Item nicht verfügbar",
--	["ItemID:"] = true,
    ["This item is not available on your server or your battlegroup yet."] = "Dieses Item ist auf deinem Server bzw. deinem Realmpool nicht verfügbar",
    ["This item is unsafe.  To view this item without the risk of disconnection, you need to have first seen it in the game world. This is a restriction enforced by Blizzard since Patch 1.10."] = "Diese Item ist unsicher.\nSobald du dieses Item ingame gesehen hast,\nbesteht nicht mehr die Gefahr eines Verbindungsabbruch\n(Es ist dann nicht mehr unsicher). Diese\nBestimmung wurde von Blizzard mit\nPatch 1.10 festgelegt.",
    ["You can right-click to attempt to query the server.  You may be disconnected."] = "Mit einem Rechtsklick wird der\nServer nach dem Item abgefragt, dabei\nkönnte die Verbindung unterbrochen werden.",

    --Misc Inventory related words
    ["Mount"] = "Reittier",
    ["Enchant"] = "Verzauberung",
    ["Trade Goods"] = "Handelswaren",
    ["Scope"] = "Zielfernrohr",
    ["Pet"] = "Haustier",
    ["Darkmoon Faire Card"] = "Dunkelmond-Karte",
    ["Book"] = "Buchband",
	--    ["Banner"] = true,
	--    ["Set"] = true,
    ["Token"] = "Gutschein",
    ["Crafting Reagent"] = "Reagenz",
    ["Skinning Knife"] = "Kürschnermesser",
    ["Herbalism Knife"] = "Kräuterkundemesser",
    ["Fish"] = "Fisch",
    ["Combat Pet"] = "Haustier (Kampf)",
    ["Fireworks"] = "Feuerwerk",

    --Extra inventory stuff
    ["Cloak"] = "Umhang",
    ["Weapons"] = "Waffen",

    --Labels for loot descriptions
    ["Classes:"] = "Klassen:",
    ["This Item Begins a Quest"] = "Dieser Gegenstand startet eine Quest",
    ["Quest Item"] = "Questgegenstand",
    ["Quest Reward"] = "Questbelohnung",
    ["Shared"] = "geteilter Loot",
    ["Unique"] = "Einzigartig",
    ["Right Half"] = "Rechte Hälfte",
    ["Left Half"] = "Linke Hälfte",
    ["28 Slot Soul Shard"] = "28er-Behälter Seelensplitter",
    ["20 Slot"] = "20 Platz",
    ["18 Slot"] = "18 Platz",
    ["16 Slot"] = "16 Platz",
    ["10 Slot"] = "10 Platz",
    ["(has random enchantment)"] = "(zufällige Verzauberung)",
    ["Use to purchase rewards"] = "Zum Kaufen von Belohnungen",
    ["Use to purchase rewards (Horde)"] = "Zum Kaufen von Belohnungen (Horde)",
    ["Use to purchase rewards (Alliance)"] = "Zum Kaufen von Belohnungen (Allianz)",
    ["World Bosses"] = "Weltbosse",
    ["Reputation Factions"] = "Ruf-Fraktionen",
    ["Sets/Collections"] = "Sets/Sammlungen",
    ["Card Game Item"] = "Kartenspiel Item",
	--    ["Tier 4"] = true,
	--    ["Tier 5"] = true,
	--    ["Tier 6"] = true,
    ["Arena Reward"] = "Arena Belohnung",
    ["Conjured Item"] = "Verbrauchbar",
    ["Used to summon boss"] = "Zur Beschwörung benötigt (Boss)",
	--    ["Phase 1"] = true,
	--    ["Phase 2"] = true,
	--    ["Phase 3"] = true,
    ["Fire"] = "Feuer",
    ["Water"] = "Wasser",
    ["Wind"] = "Wind",
    ["Earth"] = "Erde",
    ["Master Angler"] = "Anglermeister",
    ["First Prize"] = "Hauptpreis",
    ["Rare Fish Rewards"] = "Besonderer Fisch - Belohnungen",
    ["Rare Fish"] = "Besondere Fische",
	["Tradable against sunmote + item above"] = "Tausch:obiges Item + Sonnenpartikel",
	["Rare"] = "Rare",
	["Heroic"] = "Heroic",
	["Summon"] = "Summon",
	["Random"] = "Random",
    ["Weapons"] = "Waffen",

    --Card Game Decks and descriptions
    ["Upper Deck Card Game Items"] = "Upper Deck Kartenspiel Items",
    ["Heroes of Azeroth"] = "Helden von Azeroth",
    ["Through The Dark Portal"] = "Durch das Dunkle Portal",
    ["Fires of Outland"] = "Feuer der Scherbenwelt",
    ["Servants of the Betrayer"] = "Diener des Verräters",
    ["Hunt for Illidan"] = "Die Jagd nach Illidan",
    ["Drums of Wars"] = "Trommeln des Krieges",
    ["Loot Card Items"] = "Beutekarten Gegenstände",
    ["UDE Items"] = "UDE Gegenstände",
    ["Landro Longshot"] = "Landro Fernblick",
    ["Thunderhead Hippogryph"] = "Donnerkopfhippogryph",
    ["Saltwater Snapjaw"] = "Salzwasserschnappkiefer",
    ["King Mukla"] = "König Mukla",
    ["Rest and Relaxation"] = "Ruhe und Entspannung",
    ["Fortune Telling"] = "Wahrsagen",
    ["Goblin Gumbo"] = "Goblineintopf",
    ["Gone Fishin'"] = "Bin Angeln'",
    ["Spectral Tiger"] = "Spektraltiger",
    ["March of the Legion"] = "Marsch der Legion",
    ["Kiting"] = "Papierdrachen",
    ["Robotic Homing Chicken"] = "Raketenhühnchen",
    ["Paper Airplane"] = "Papierflugmaschine",
    ["Papa Hummel's Old-fashioned Pet Biscuit"] = "Papa Hummels altmodischer Tierkuchen",
    ["Personal Weather Machine"] = "Persönlicher Wettermacher",
    ["X-51 Nether-Rocket"] = "X-51 Netherrakete",
    ["The Footsteps of Illidan"] = "Die Fußspuren von Illidan",
    ["Disco Inferno!"] = "Disko-Inferno",
    ["Ethereal Plunderer"] = "Astraler Brandschatzer",

    --Battleground Brackets
    ["Misc. Rewards"] = "Diverses",
    ["Superior Rewards"] = "Seltene Items",
    ["Epic Rewards"] = "Epische Items",
    ["Level 10-19 Rewards"] = "Belohnungen (Level 10-19)",
    ["Level 20-29 Rewards"] = "Belohnungen (Level 20-29)",
    ["Level 30-39 Rewards"] = "Belohnungen (Level 30-39)",
    ["Level 40-49 Rewards"] = "Belohnungen (Level 40-49)",
    ["Level 50-59 Rewards"] = "Belohnungen (Level 50-59)",
    ["Level 60 Rewards"] = "Belohnungen (Level 60)",

    --Brood of Nozdormu Paths
    ["Path of the Conqueror"] = "Der Pfad des Eroberers",
    ["Path of the Invoker"] = "Der Pfad des Herbeirufers",
    ["Path of the Protector"] = "Der Pfad des Beschützers",

    --Violet Eye Paths
    ["Path of the Violet Protector"] = "Violetter Beschützer",
    ["Path of the Violet Mage"] = "Violetter Magier",
    ["Path of the Violet Assassin"] = "Violetter Auftragsmörder",
    ["Path of the Violet Restorer"] = "Violetter Bewahrer",

    --AQ Opening Event
    ["Red Scepter Shard"] = "Roter Szeptersplitter",
    ["Blue Scepter Shard"] = "Blauer Szeptersplitter",
    ["Green Scepter Shard"] = "Grüner Szeptersplitter",
    ["Scepter of the Shifting Sands"] = "Das Szepter der Sandstürme",

    --World PvP
    ["Hellfire Fortifications"] = "Befestigung des Höllenfeuers",
    ["Twin Spire Ruins"] = "Ruinen der Zwillingsspitze",
    ["Spirit Towers"] = "Geistertürme",
	--    ["Halaa"] = true,

    --Karazhan Opera Event Headings
    ["Shared Drops"] = "geteilter Loot",
	--    ["Romulo & Julianne"] = true,
    ["Wizard of Oz"] = "Zauberer von Oz",
    ["Red Riding Hood"] = "Rotkäppchen",

    --Karazhan Animal Boss Types
    ["Spider"] = "Spinne",
    ["Darkhound"] = "Schattenhund",
    ["Bat"] = "Fledermaus",

    --ZG Tokens
    ["Primal Hakkari Kossack"] = "Hakkarikosak",
    ["Primal Hakkari Shawl"] = "Hakkarischal",
    ["Primal Hakkari Bindings"] = "Hakkaribindungen",
    ["Primal Hakkari Sash"] = "Hakkarischärpe",
    ["Primal Hakkari Stanchion"] = "Hakkaristütze",
    ["Primal Hakkari Aegis"] = "Aegis der Hakkari",
    ["Primal Hakkari Girdle"] = "Hakkarigurt",
    ["Primal Hakkari Armsplint"] = "Hakkariarmsplintes",
    ["Primal Hakkari Tabard"] = "Hakkariwappenrock",

    --AQ20 Tokens
    ["Qiraji Ornate Hilt"] = "Verschnörkelter Griff",
    ["Qiraji Martial Drape"] = "Kampftuch",
    ["Qiraji Magisterial Ring"] = "Gebieterring",
    ["Qiraji Ceremonial Ring"] = "Zeremonienring",
    ["Qiraji Regal Drape"] = "Hoheitstuch",
    ["Qiraji Spiked Hilt"] = "Stachelgriff",

    --AQ40 Tokens
    ["Qiraji Bindings of Dominance"] = "Dominanzbindungen",
    ["Qiraji Bindings of Command"] = "Befehlsbindungen",
    ["Vek'nilash's Circlet"] = "Vek'nilashs Reif",
    ["Vek'lor's Diadem"] = "Vek'lors Diadem",
    ["Ouro's Intact Hide"] = "Ouros intakte Haut",
    ["Skin of the Great Sandworm"] = "Haut des Sandwurms",
    ["Husk of the Old God"] = "Hülle des Gottes",
    ["Carapace of the Old God"] = "Knochenpanzer des Gottes",

    --Blacksmithing Crafted Sets
    ["Imperial Plate"] = "Stolz des Imperiums",
    ["The Darksoul"] = "Die dunkle Seele",
    ["Fel Iron Plate"] = "Teufelseisenplattenrüstung",
    ["Adamantite Battlegear"] = "Adamantitschlachtrüstung",
    ["Flame Guard"] = "Flammenwächter",
    ["Enchanted Adamantite Armor"] = "Verzauberte Adamantitrüstung",
    ["Khorium Ward"] = "Khoriumschutz",
    ["Faith in Felsteel"] = "Teufelsstählerner Wille",
    ["Burning Rage"] = "Brennernder Zorn",
    ["Bloodsoul Embrace"] = "Umarmung der Blutseele",
    ["Fel Iron Chain"] = "Teufelseisenkettenrüstung",

    --Tailoring Crafted Sets
    ["Bloodvine Garb"] = "Blutrebengewand",
    ["Netherweave Vestments"] = "Netherstoffgewänder",
    ["Imbued Netherweave"] = "Magieerfüllte Netherstoffroben",
    ["Arcanoweave Vestments"] = "Arkanostoffgewänder",
    ["The Unyielding"] = "Der Unerschütterliche",
    ["Whitemend Wisdom"] = "Weisheit des weißen Heilers",
    ["Spellstrike Infusion"] = "Insignien des Zauberschlags",
    ["Battlecast Garb"] = "Gewand des Schlachtenzaubers",
    ["Soulcloth Embrace"] = "Seelenstoffumarmung",
    ["Primal Mooncloth"] = "Urmondroben",
    ["Shadow's Embrace"] = "Umarmung der Schatten",
    ["Wrath of Spellfire"] = "Zorn des Zauberfeuers",

    --Leatherworking Crafted Sets
    ["Volcanic Armor"] = "Vulkanrüstung",
    ["Ironfeather Armor"] = "Eisenfederrüstung",
    ["Stormshroud Armor"] = "Sturmschleier",
    ["Devilsaur Armor"] = "Teufelsaurierrüstung",
    ["Blood Tiger Harness"] = "Harnisch des Bluttigers",
    ["Primal Batskin"] = "Urzeitliche Fledermaushaut",
    ["Wild Draenish Armor"] = "Wilde draenische Rüstung",
    ["Thick Draenic Armor"] = "Dicke draenische Rüstung",
    ["Fel Skin"] = "Teufelshaut",
    ["Strength of the Clefthoof"] = "Macht der Grollhufe",
    ["Green Dragon Mail"] = "Grüner Drachenschuppenpanzer",
    ["Blue Dragon Mail"] = "Blauer Drachenschuppenpanzer",
    ["Black Dragon Mail"] = "Schwarzer Drachenschuppenpanzer",
    ["Scaled Draenic Armor"] = "Geschuppte draenische Rüstung",
    ["Felscale Armor"] = "Teufelsschuppenrüstung",
    ["Felstalker Armor"] = "Rüstung des Teufelspirschers",
    ["Fury of the Nether"] = "Netherzorn",
    ["Primal Intent"] = "Urinstinkt",
    ["Windhawk Armor"] = "Rüstung des Windfalken",
    ["Netherscale Armor"] = "Netherschuppenrüstung",
    ["Netherstrike Armor"] = "Rüstung des Netherstoßes",

    --Vanilla WoW Sets
    ["Defias Leather"] = "Defiasleder",
    ["Embrace of the Viper"] = "Umarmung der Viper",
    ["Chain of the Scarlet Crusade"] = "Kettenrüstung des Scharlachroten Kreuzzugs",
    ["The Gladiator"] = "Der Gladiator",
    ["Ironweave Battlesuit"] = "Eisengewebte Kampfrüstung",
    ["Necropile Raiment"] = "Roben des Totenbeschwörers",
    ["Cadaverous Garb"] = "Leichenhaftes Gewand",
    ["Bloodmail Regalia"] = "Ornat des Blutpanzers",
    ["Deathbone Guardian"] = "Wächter der Totengebeine",
    ["The Postmaster"] = "Der Postmeister",
    ["Scourge Invasion"] = "Invasion der Geißel",
    ["Regalia of Undead Cleansing"] = "Ornat der Untotenbekämpfung",
    ["Undead Slayer's Armor"] = "Rüstung des Untotenschlächters",
    ["Garb of the Undead Slayer"] = "Gewand des Untotenschlächters",
    ["Battlegear of Undead Slaying"] = "Kampfrüstung des Untotenschlachtens",
    ["Shard of the Gods"] = "Scherbe der Götter",
    ["Zul'Gurub Rings"] = "Zul'Gurub Ringe" ,
    ["Major Mojo Infusion"] = "Kraft des Mojo",
    ["Overlord's Resolution"] = "Erlass des Oberherren",
    ["Prayer of the Primal"] = "Gebet der Uralten",
    ["Zanzil's Concentration"] = "Zanzils Konzentration",
    ["Spirit of Eskhandar"] = "Seele des Eskhandar",
    ["The Twin Blades of Hakkari"] = "Die Zwillingsklingen von Hakkari",
    ["Primal Blessing"] = "Ursegen",
    ["Dal'Rend's Arms"] = "Dal'Rends Waffen",
    ["Spider's Kiss"] = "Kuss der Spinne",

    --The Burning Crusade Sets
	["Latro's Flurry"] = "Latros Schlaghagel",
    ["The Twin Stars"] = "Die Zwillingssterne",
    ["The Twin Blades of Azzinoth"] = "Die Zwillingsklingen von Azzinoth",

    --ZG Sets
    ["Haruspex's Garb"] = "Gewand des Haruspex",
    ["Predator's Armor"] = "Rüstung des Raubtiers",
    ["Illusionist's Attire"] = "Roben des Illusionisten",
    ["Freethinker's Armor"] = "Rüstung des Freidenkers",
    ["Confessor's Raiment"] = "Gewand des Glaubenshüters",
    ["Madcap's Outfit"] = "Rüstzeug des Wildfangs",
    ["Augur's Regalia"] = "Ornat des Weissagers",
    ["Demoniac's Threads"] = "Roben des Besessenen",
    ["Vindicator's Battlegear"] = "Schlachtrüstung des Vollstreckers",

    --AQ20 Sets
    ["Symbols of Unending Life"] = "Symbole des endlosen Lebens",
    ["Trappings of the Unseen Path"] = "Zierat des unsichtbaren Pfades",
    ["Trappings of Vaulted Secrets"] = "Zierat der behüteten Geheimnisse",
    ["Battlegear of Eternal Justice"] = "Schlachtrüstung der ewigen Gerechtigkeit",
    ["Finery of Infinite Wisdom"] = "Pracht der unendlichen Weisheit",
    ["Emblems of Veiled Shadows"] = "Embleme der Schattenschleier",
    ["Gift of the Gathering Storm"] = "Gabe der aufziehenden Stürme",
    ["Implements of Unspoken Names"] = "Ritualroben des ungesagten Namens",
    ["Battlegear of Unyielding Strength"] = "Schlachtrüstung der unnachgiebigen Stärke",

    --AQ40 Sets
    ["Genesis Raiment"] = "Gewandung der Genesis",
    ["Striker's Garb"] = "Gewand des Hetzers",
    ["Enigma Vestments"] = "Gewänder des Mysteriums",
    ["Avenger's Battlegear"] = "Schlachtrüstung des Rächers",
    ["Garments of the Oracle"] = "Gewänder des Orakels",
    ["Deathdealer's Embrace"] = "Umarmung des Todesboten",
    ["Stormcaller's Garb"] = "Gewand des Sturmrufers",
    ["Doomcaller's Attire"] = "Roben des Verdammnisrufers",
    ["Conqueror's Battlegear"] = "Schlachtrüstung des Eroberers",

    --Dungeon 1 Sets
    ["Wildheart Raiment"] = "Herz der Wildnis",
    ["Beaststalker Armor"] = "Rüstung des Bestienjägers",
    ["Magister's Regalia"] = "Ornat des Magisters",
    ["Lightforge Armor"] = "Esse des Lichts",
    ["Vestments of the Devout"] = "Gewänder des Gläubigen",
    ["Shadowcraft Armor"] = "Rüstung der Schattenkunst",
    ["The Elements"] = "Die Elemente",
    ["Dreadmist Raiment"] = "Nebel der Furcht",
    ["Battlegear of Valor"] = "Schlachtrüstung der Ehre",

    --Dungeon 2 Sets
    ["Feralheart Raiment"] = "Ungezähmtes Herz",
    ["Beastmaster Armor"] = "Rüstung der Tierherrschaft",
    ["Sorcerer's Regalia"] = "Ornat der Zauberkünste",
    ["Soulforge Armor"] = "Rüstung der Seelenschmiede",
    ["Vestments of the Virtuous"] = "Gewänder des Tugendhaften",
    ["Darkmantle Armor"] = "Rüstung der Finsternis",
    ["The Five Thunders"] = "Die fünf Donner",
    ["Deathmist Raiment"] = "Roben des Todesnebels",
    ["Battlegear of Heroism"] = "Schlachtrüstung des Heldentums",

    --Dungeon 3 Sets
    ["Hallowed Raiment"] = "Geheiligte Roben",
    ["Incanter's Regalia"] = "Ornat des Beschwörens",
    ["Mana-Etched Regalia"] = "Managetränktes Ornat",
    ["Oblivion Raiment"] = "Gewandung des Vergessens",
    ["Assassination Armor"] = "Rüstung des Meuchelmords",
    ["Moonglade Raiment"] = "Gewandung der Mondlichtung",
    ["Wastewalker Armor"] = "Ödniswandlerrüstung",
    ["Beast Lord Armor"] = "Rüstung des Wildtierfürsten",
    ["Desolation Battlegear"] = "Schlachtrüstung der Verwüstung",
    ["Tidefury Raiment"] = "Gewandung des Gezeitensturms",
    ["Bold Armor"] = "Rüstung des Wagemutigen",
    ["Doomplate Battlegear"] = "Verdammnisplattenrüstung",
    ["Righteous Armor"] = "Rüstung des Rechtschaffenen",

    --Tier 1 Sets
    ["Cenarion Raiment"] = "Gewänder des Cenarius",
    ["Giantstalker Armor"] = "Rüstung des Riesenjägers",
    ["Arcanist Regalia"] = "Ornat des Arkanisten",
    ["Lawbringer Armor"] = "Rüstung der Gerechtigkeit",
    ["Vestments of Prophecy"] = "Gewänder der Prophezeihung",
    ["Nightslayer Armor"] = "Der Nachtmeuchler",
    ["The Earthfury"] = "Die Wut der Erde",
    ["Felheart Raiment"] = "Teufelsherzroben",
    ["Battlegear of Might"] = "Schlachtrüstung der Macht",

    --Tier 2 Sets
    ["Stormrage Raiment"] = "Sturmgrimms Gewänder",
    ["Dragonstalker Armor"] = "Rüstung des Drachenjägers",
    ["Netherwind Regalia"] = "Ornat des Netherwinds",
    ["Judgement Armor"] = "Rüstung des Richturteils",
    ["Vestments of Transcendence"] = "Gewänder der Erhabenheit",
    ["Bloodfang Armor"] = "Blutfangrüstung",
    ["The Ten Storms"] = "Die zehn Stürme",
    ["Nemesis Raiment"] = "Roben der Nemesis",
    ["Battlegear of Wrath"] = "Schlachtrüstung des Zorns",

    --Tier 3 Sets
    ["Dreamwalker Raiment"] = "Gewandung des Traumwandlers",
    ["Cryptstalker Armor"] = "Rüstung des Gruftpirschers",
    ["Frostfire Regalia"] = "Frostfeuerornat",
    ["Redemption Armor"] = "Rüstung der Erlösung",
    ["Vestments of Faith"] = "Gewänder des Glaubens",
    ["Bonescythe Armor"] = "Rüstung der Knochensense",
    ["The Earthshatterer"] = "Der Erdspalter",
    ["Plagueheart Raiment"] = "Roben des verseuchten Herzens",
    ["Dreadnaught's Battlegear"] = "Schlachtrüstung des Schreckenspanzers",

    --Tier 4 Sets
    ["Malorne Harness"] = "Malornes Harnisch",
    ["Malorne Raiment"] = "Malornes Gewandung",
    ["Malorne Regalia"] = "Malornes Ornat",
    ["Demon Stalker Armor"] = "Rüstung des Dämonenwandlers",
    ["Aldor Regalia"] = "Ornat der Aldor",
    ["Justicar Armor"] = "Rüstung des Rechtsprechers",
    ["Justicar Battlegear"] = "Schlachtrüstung des Rechtsprechers",
    ["Justicar Raiment"] = "Gewandung des Rechtsprechers",
    ["Incarnate Raiment"] = "Gewandung des Leibhaftigen",
    ["Incarnate Regalia"] = "Ornat des Leibhaftigen",
    ["Netherblade Set"] = "Netherklinge",
    ["Cyclone Harness"] = "Harnisch des Orkans",
    ["Cyclone Raiment"] = "Gewandung des Orkans",
    ["Cyclone Regalia"] = "Ornat des Orkans",
    ["Voidheart Raiment"] = "Gewandung des Herzens der Leere",
    ["Warbringer Armor"] = "Rüstung des Kriegshetzers",
    ["Warbringer Battlegear"] = "Schlachtrüstung des Kriegshetzers",

    --Tier 5 Sets
    ["Nordrassil Harness"] = "Harnisch von Nordrassil",
    ["Nordrassil Raiment"] = "Gewandung von Nordrassil",
    ["Nordrassil Regalia"] = "Ornat von Nordrassil",
    ["Rift Stalker Armor"] = "Rüstung des Dimensionswandlers",
    ["Tirisfal Regalia"] = "Ornat von Tirisfal",
    ["Crystalforge Armor"] = "Kristallgeschmiedete Rüstung",
    ["Crystalforge Battlegear"] = "Kristallgeschmiedete Schlachtrüstung",
    ["Crystalforge Raiment"] = "Kristallgeschmiedete Gewandung",
    ["Avatar Raiment"] = "Gewandung des Avatars",
    ["Avatar Regalia"] = "Ornat des Avatars",
    ["Deathmantle Set"] = "Todeshauch",
    ["Cataclysm Harness"] = "Harnisch der Verheerung",
    ["Cataclysm Raiment"] = "Gewandung der Verheerung",
    ["Cataclysm Regalia"] = "Ornat der Verheerung",
    ["Corruptor Raiment"] = "Gewandung des Verderbers",
    ["Destroyer Armor"] = "Rüstung des Zerstörers",
    ["Destroyer Battlegear"] = "Schlachtrüstung des Zerstörers",

    --Tier 6 Sets
    ["Thunderheart Harness"] = "Harnisch des Donnerherzens",
    ["Thunderheart Raiment"] = "Gewandung des Donnerherzens",
    ["Thunderheart Regalia"] = "Ornat des Donnerherzens",
    ["Gronnstalker's Armor"] = "Rüstung des Gronnpirschers",
    ["Tempest Regalia"] = "Ornat des Gewittersturms",
    ["Lightbringer Armor"] = "Rüstung des Lichtbringers",
    ["Lightbringer Battlegear"] = "Schlachtrüstung des Lichtbringers",
    ["Lightbringer Raiment"] = "Gewandung des Lichtbringers",
    ["Vestments of Absolution"] = "Ornat der Absolution",
    ["Absolution Regalia"] = "Gewänder der Absolution",
    ["Slayer's Armor"] = "Rüstung des Schlächters",
    ["Skyshatter Harness"] = "Harnisch des Himmelsdonners",
    ["Skyshatter Raiment"] = "Gewandung des Himmelsdonners",
    ["Skyshatter Regalia"] = "Ornat des Himmelsdonners",
    ["Malefic Raiment"] = "Gewandung der Boshaftigkeit",
    ["Onslaught Armor"] = "Rüstung des Ansturms",
    ["Onslaught Battlegear"] = "Schlachtrüstung des Ansturms",

    --Arathi Basin Sets - Alliance
    ["The Highlander's Intent"] = "Brennender Eifer des Highlanders",
    ["The Highlander's Purpose"] = "Schicksalsmacht des Highlanders",
    ["The Highlander's Will"] = "Feuriger Wille des Highlanders",
    ["The Highlander's Determination"] = "Inbrunst des Highlanders",
    ["The Highlander's Resolution"] = "Unbeugsamkeit des Highlanders",
    ["The Highlander's Resolve"] = "Entschlossenheit des Highlanders",

    --Arathi Basin Sets - Horde
    ["The Defiler's Intent"] = "Brennender Eifer der Entweihten",
    ["The Defiler's Purpose"] = "Schicksalsmacht der Entweihten",
    ["The Defiler's Will"] = "Feuriger Wille der Entweihten",
    ["The Defiler's Determination"] = "Inbrunst der Entweihten",
    ["The Defiler's Fortitude"] = "Seelenkraft der Entweihten",
    ["The Defiler's Resolution"] = "Unbeugsamkeit der Entweihten",

    --PvP Level 60 Rare Sets - Alliance
    ["Lieutenant Commander's Refuge"] = "Haingewand des Feldkommandanten",
    ["Lieutenant Commander's Pursuance"] = "Jagdrüstung des Feldkommandanten",
    ["Lieutenant Commander's Arcanum"] = "Arkanum des Feldkommandanten",
    ["Lieutenant Commander's Redoubt"] = "Zeremonienrüstung des Feldkommandanten",
    ["Lieutenant Commander's Investiture"] = "Würdengewand des Feldkommandanten",
    ["Lieutenant Commander's Guard"] = "Gewänder des Feldkommandanten",
    ["Lieutenant Commander's Stormcaller"] = "Sturmornat des Feldkommandanten",
    ["Lieutenant Commander's Dreadgear"] = "Schreckensrüstung des Feldkommandanten",
    ["Lieutenant Commander's Battlearmor"] = "Sturmrüstung des Feldkommandanten",

    --PvP Level 60 Rare Sets - Horde
    ["Champion's Refuge"] = "Haingewand des Feldherren",
    ["Champion's Pursuance"] = "Jagdrüstung des Feldherren",
    ["Champion's Arcanum"] = "Arkanum des Feldherren",
    ["Champion's Redoubt"] = "Zeremonierüstung des Feldherren",
    ["Champion's Investiture"] = "Würdengewand des Feldherren",
    ["Champion's Guard"] = "Gewänder des Feldherren",
    ["Champion's Stormcaller"] = "Sturmornat des Feldherren",
    ["Champion's Dreadgear"] = "Schreckensrüstung des Feldherren",
    ["Champion's Battlearmor"] = "Sturmrüstung des Feldherren",

    --PvP Level 60 Epic Sets - Alliance
    ["Field Marshal's Sanctuary"] = "Zierat des Feldmarschalls",
    ["Field Marshal's Pursuit"] = "Lohn des Feldmarschalls",
    ["Field Marshal's Regalia"] = "Ornat des Feldmarschalls",
    ["Field Marshal's Aegis"] = "Aegis des Feldmarschalls",
    ["Field Marshal's Raiment"] = "Gewandung des Feldmarschalls",
    ["Field Marshal's Vestments"] = "Gewänder des Feldmarschalls",
    ["Field Marshal's Earthshaker"] = "Erderschütterer des Feldmarschalls",
    ["Field Marshal's Threads"] = "Roben des Feldmarschalls",
    ["Field Marshal's Battlegear"] = "Schlachtrüstung des Feldmarschalls",

    --PvP Level 60 Epic Sets - Horde
    ["Warlord's Sanctuary"] = "Zierat des Kriegsfürsten",
    ["Warlord's Pursuit"] = "Lohn des des Kriegsfürsten",
    ["Warlord's Regalia"] = "Ornat des Kriegsfürsten",
    ["Warlord's Aegis"] = "Aegis des Kriegsfürsten",
    ["Warlord's Raiment"] = "Gewandung des Kriegsfürsten",
    ["Warlord's Vestments"] = "Gewänder des Kriegsfürsten",
    ["Warlord's Earthshaker"] = "Erderschütterer des Kriegsfürsten",
    ["Warlord's Threads"] = "Roben des Kriegsfürsten",
    ["Warlord's Battlegear"] = "Schlachtrüstung des Kriegsfürsten",

    --Outland Faction Reputation PvP Sets
	["Dragonhide Battlegear"] = "Schlachtrüstung aus Drachenleder",
	["Wyrmhide Battlegear"] = "Schlachtrüstung aus Wyrmbalg",
	["Kodohide Battlegear"] = "Schlachtrüstung aus Kodobalg",
	["Stalker's Chain Battlegear"] = "Kettenschlachtrüstung des Pirschers",
	["Evoker's Silk Battlegear"] = "Seidene Schlachtrüstung des Beschwörers",
	["Crusader's Scaled Battledgear"] = "Schuppenschlachtrüstung des Kreuzfahrers",
	["Crusader's Ornamented Battledgear"] = "Zieratschlachtrüstung des Kreuzfahrers",
	["Satin Battlegear"] = "Schlachtrüstung aus Satin",
	["Mooncloth Battlegear"] = "Schlachtrüstung aus Mondstoff",
	["Opportunist's Battlegear"] = "Schlachtrüstung des Heuchlers",
	["Seer's Linked Battlegear"] = "Gekettelte Schlachtrüstung des Sehers",
	["Seer's Mail Battlegear"] = "Schwere Schlachtrüstung des Sehers",
	["Seer's Ringmail Battlegear"] = "Ringpanzerschlachtrüstung des Sehers",
	["Dreadweave Battlegear"] = "Schlachtrüstung aus Schreckenszwirn",
	["Savage's Plate Battlegear"] = "Wilde Plattenschlachtrüstung",

    --Arena Epic Sets
    ["Gladiator's Sanctuary"] = "Schutzgewandung des Gladiators",
    ["Gladiator's Wildhide"] = "Wildfell des Gladiators",
    ["Gladiator's Refuge"] = "Zuflucht des Gladiators",
    ["Gladiator's Pursuit"] = "Jagdtracht des Gladiators",
    ["Gladiator's Regalia"] = "Ornat des Gladiators",
    ["Gladiator's Aegis"] = "Aegis des Gladiators",
    ["Gladiator's Vindication"] = "Rechtschaffenheit des Gladiators",
    ["Gladiator's Redemption"] = "Erlösung des Gladiators",
    ["Gladiator's Raiment"] = "Gewandung des Gladiators",
    ["Gladiator's Investiture"] = "Vereidigung des Gladiators",
    ["Gladiator's Vestments"] = "Gewänder des Gladiators",
    ["Gladiator's Earthshaker"] = "Erderschütterer des Gladiators",
    ["Gladiator's Thunderfist"] = "Donnerfaust des Gladiators",
    ["Gladiator's Wartide"] = "Kriegsrausch des Gladiators",
    ["Gladiator's Dreadgear"] = "Schreckensrüstung des Gladiators",
    ["Gladiator's Felshroud"] = "Teufelsschleier des Gladiators",
    ["Gladiator's Battlegear"] = "Schlachtrüstung des Gladiators",

    --Set Labels
    ["Set: Embrace of the Viper"] = "Set: Umarmung der Viper (5 Teile)",
    ["Set: Defias Leather"] = "Set: Defiasleder (5 Teile)",
    ["Set: The Gladiator"] = "Set: Der Gladiator (5 Teile)",
    ["Set: Chain of the Scarlet Crusade"] = "Set: Kettenrüstung des Scharlachroten Kreuzzugs",
    ["Set: The Postmaster"] = "Der Postmeister (5 Teile)",
    ["Set: Necropile Raiment"] = "Set: Roben des Totenbeschwörers (5 Teile)",
    ["Set: Cadaverous Garb"] = "Set: Leichenhaftes Gewand (5 Teile)",
    ["Set: Bloodmail Regalia"] = "Set: Ornat des Blutpanzers (5 Teile)",
    ["Set: Deathbone Guardian"] = "Set: Wächter der Totengebeine (5 Teile)",
    ["Set: Dal'Rend's Arms"] = "Set: Dal'Rends Waffen (2 Teile)",
    ["Set: Spider's Kiss"] = "Set: Kuss der Spinne (2 Teile)",
    ["Temple of Ahn'Qiraj Sets"] = "Tempel von Ahn'Qiraj Sets",
    ["AQ40 Class Sets"] = "AQ40-Klassen-Sets",
    ["Ruins of Ahn'Qiraj Sets"] = "Ruinen von Ahn'Qiraj Sets",
    ["AQ20 Class Sets"] = "AQ20-Klassen-Sets",
    ["AQ Enchants"] = "AQ-Verzauberungen",
    ["AQ Opening Quest Chain"] = "AQ-Öffnungsquestreihe",
    ["Pre 60 Sets"] = "Sets (Low Level)",
    ["Crafted Sets"] = "Sets (Berufe)",
    ["Crafted Epic Weapons"] = "Geschmiedete epische Waffen",
    ["Zul'Gurub Sets"] = "Zul'Gurub Sets",
    ["ZG Class Sets"] = "ZG-Klassen-Sets",
    ["ZG Enchants"] = "ZG-Verzauberungen",
	--    ["Dungeon 1/2 Sets"] = true,
	--    ["Dungeon Set 1"] = true,
	--    ["Dungeon Set 2"] = true,
	--    ["Dungeon 3 Sets"] = true,
	--    ["Tier 1/2 Sets"] = true,
	--    ["Tier 3 Sets"] = true,
	--    ["Tier 4 Sets"] = true,
	--    ["Tier 5 Sets"] = true,
	--    ["Tier 6 Sets"] = true,
	--    ["PvP Sets (Level 60)"] = true,
	--    ["PvP Sets (Level 70)"] = true,
    ["PvP Reputation Sets (Level 70)"] = "PvP Ruf Sets (Level 70)",
    ["PvP Rewards (Level 60)"] = "PvP-Belohnungen (Level 60)",
    ["PvP Rewards (Level 70)"] = "PvP-Belohnungen (Level 70)",
    ["PvP Accessories (Level 60)"] = "PvP-Zubehör (Level 60)",
	--    ["PvP Accessories - Alliance (Level 60)"] = true,
	--    ["PvP Accessories - Horde (Level 60)"] = true,
    ["PvP Accessories (Level 70)"] = "PvP-Zubehör (Level 70)",
    ["PvP Rewards"] = "PvP",
    ["PvP Armor Sets"] = "PvP-Rüstungssets",
    ["PvP Weapons"] = "PvP-Waffen",
	--    ["PvP Weapons (Level 60)"] = true,
	--    ["PvP Weapons (Level 70)"] = true,
    ["PvP Accessories"] = "PvP-Zubehör",
    ["PvP Non-Set Epics"] = "PvP Nicht-Set Epics",
    ["PvP Honor System"] = "PvP Ehren System",
	--    ["PvP Reputation Sets"] = true,
	--    ["Arena PvP Sets"] = true,
	--    ["Arena 2 PvP Sets"] = true,
	--    ["Arena 3 PvP Sets"] = true,
	--    ["Arena 4 PvP Sets"] = true,
    ["Arena PvP Weapons"] = "Arena PvP Waffen",
    ["Arena 2 PvP Weapons"] = "Arena 2 PvP Waffen",
    ["Arena 3 PvP Weapons"] = "Arena 3 PvP Waffen",
    ["Arena 4 PvP Weapons"] = "Arena 4 PvP Waffen",
	--    ["Arena PvP System"] = true,
	--    ["Arena Season 1 Weapons"] = true,
	--    ["Arena Season 2 Weapons"] = true,
	--    ["Arena Season 3 Weapons"] = true,
	--    ["Arena Season 4 Weapons"] = true,
    ["Season 1"] = "1. Saison",
    ["Season 2"] = "2. Saison",
    ["Season 3"] = "3. Saison",
    ["Season 4"] = "4. Saison",
    ["Arathi Basin Sets"] = "Arathibecken Sets",
    ["Class Books"] = "Klassenbücher",
    ["Tribute Run"] = "Tribut Run",
    ["Dire Maul Books"] = "Düsterbruch Bücher",
    ["Random Boss Loot"] = "Zufälliger Boss Loot",
    ["Class Set Pieces"] = "Klassen-Set Teile",
    ["Epic Set"] = "Episches Set",
    ["Rare Set"] = "Seltenes Set",
    ["Legendary Items"] = "Legendäre Items",
    ["Badge of Justice Rewards"] = "Abzeichen der Gerechtigkeit",
    ["Accesories and Weapons"] ="Zubehör und Waffen",
    ["Accessories"] = "Zubehör",
    ["Armor and Weapons"] = "Rüstung und Waffen",
    ["Fire Resistance Gear"] = "Feuerresistenz",
    ["Arcane Resistance Gear"] = "Arkanresistenz",
    ["Nature Resistance Gear"] = "Naturresistenz",
    ["Frost Resistance Gear"] = "Frostresistenz",
    ["Shadow Resistance Gear"] = "Schattenresistenz",
    ["Rare Mounts"] = "Seltene Reittiere",
    ["Tabards"] = "Wappenröcke",
    ["Token Hand-Ins"] = "Gutscheine",
    ["Heroic Mode Keys"] = "Schlüssel: Heroisch",
    ["Legendary Items for Kael'thas Fight"] = "Legendäre Items für Kael'thas Kampf",
    ["BoE World Epics"] = "Epische Weltdrops (BoE)",
    ["World Epics"] = "Epische Weltdrops",
	--    ["Level 30-39"] = true,
	--    ["Level 40-49"] = true,
	--    ["Level 50-60"] = true,
    ["BT Patterns/Plans"] = "BT Muster/Pläne",
    ["Hyjal Summit Designs"] = "Berg Hyjal Designs",
    ["SP Patterns/Plans"] = "SP Muster/Pläne",

    --NPCs missing from BabbleBoss
	--    ["Trash Mobs"] = true,
    ["Dungeon Set 2 Summonable"] = "Beschworener Boss (DS2)",
    ["Highlord Kruul"] = "Hochlord Kruul",
	--    ["Theldren"] = true,
    ["Sothos and Jarien"] = "Sothos und Jarien",
    ["Druid of the Fang"] = "Druiden des Giftzahns",
    ["Defias Strip Miner"] = "Akkordminenarbeiter der Defias",
    ["Defias Overseer/Taskmaster"] = "Vorarbeiter/Zuchtmeister der Defias",
    ["Scarlet Defender/Myrmidon"] = "Scharlachroter Myrmidone/Verteidiger",
    ["Scarlet Champion"] = "Scharlachroter Held",
    ["Scarlet Centurion"] = "Scharlachroter Zenturio",
    ["Scarlet Trainee"] = "Scharlachroter Lehrling",
	--    ["Herod/Mograine"] = true,
    ["Scarlet Protector/Guardsman"] = "Scharlachroter Beschützer/Gardist",
    ["Shadowforge Flame Keeper"] = "Flammenbewahrer der Schattenschmiede",
	--    ["Olaf"] = true,
    ["Eric 'The Swift'"] = "Eric 'Der Flinke'",
    ["Shadow of Doom"] = "Schatten der Verdammnis",
    ["Bone Witch"] = "Knochenhexe",
    ["Lumbering Horror"] = "Schwerfälliger Horror",
    ["Avatar of the Martyred"] = "Avatar des Gemarterten",
	--    ["Yor"] = true,
    ["Nexus Stalker"] = "Nexuswandler",
    ["Auchenai Monk"] = "Mönch der Auchenai",
    ["Cabal Fanatic"] = "Fanatiker der Kabale",
    ["Unchained Doombringer"] = "Entfesselter Verdammnisbringer",
    ["Crimson Sorcerer"] = "Purpurroter Zauberhexer",
    ["Thuzadin Shadowcaster"] = "Thuzadinschattenzauberer",
    ["Crimson Inquisitor"] = "Purpurroter Inquisitor",
    ["Crimson Battle Mage"] = "Purpurroter Kampfmagier",
    ["Ghoul Ravener"] = "Tobsüchtiger Ghul",
    ["Spectral Citizen"] = "Spektraler Bürger",
    ["Spectral Researcher"] = "Spektraler Forscher",
    ["Scholomance Adept"] = "Adept aus Scholomance",
    ["Scholomance Dark Summoner"] = "Dunkler Beschwörer aus Scholomance",
    ["Blackhand Elite"] = "Elitesoldat der Schwarzfaustlegion",
    ["Blackhand Assassin"] = "Auftragsmörder der Schwarzfaustlegion",
    ["Firebrand Pyromancer"] = "Pyromant der Feuerbrand",
    ["Firebrand Invoker"] = "Herbeirufer der Feuerbrand",
    ["Firebrand Grunt"] = "Grunzer der Feuerbrand",
    ["Firebrand Legionnaire"] = "Legionär der Feuerbrand",
    ["Spirestone Warlord"] = "Kriegsherr der Felsspitzoger",
    ["Spirestone Mystic"] = "Mystiker der Felsspitzoger",
    ["Anvilrage Captain"] = "Hauptmann der Zorneshämmer",
    ["Anvilrage Marshal"] = "Marschall der Zorneshämmer",
    ["Doomforge Arcanasmith"] = "Schicksalsträchtiger Arkanaschmied",
    ["Weapon Technician"] = "Waffentechniker",
    ["Doomforge Craftsman"] = "Schicksalsträchtiger Handwerker",
    ["Murk Worm"] = "Düsterwurm",
    ["Atal'ai Witch Doctor"] = "Hexendoktor der Atal'ai",
    ["Raging Skeleton"] = "Tobendes Skelett",
    ["Ethereal Priest"] = "Astraler Priester",
    ["Sethekk Ravenguard"] = "Rabenwächter der Sethekk",
    ["Time-Lost Shadowmage"] = "Zeitverlorener Schattenmagier",
    ["Coilfang Sorceress"] = "Zauberhexerin des Echsenkessels",
    ["Coilfang Oracle"] = "Orakel des Echsenkessels",
    ["Shattered Hand Centurion"] = "Zenturio der Zerschmetterten Hand",
    ["Eredar Deathbringer"] = "Todesbringer der Eredar",
    ["Arcatraz Sentinel"] = "Schildwache der Arkatraz",
    ["Gargantuan Abyssal"] = "Riesengroßer Abyss",
    ["Sunseeker Botanist"] = "Botaniker der Sonnensucher",
    ["Sunseeker Astromage"] = "Astromagier der Sonnensucher",
    ["Durnholde Rifleman"] = "Scharfschütze von Durnholde",
    ["Rift Keeper/Rift Lord"] = "Bewahrerin/Fürst der Zeitenrisse",
    ["Crimson Templar"] = "Purpurroter Templer",
    ["Azure Templar"] = "Azurblauer Templer",
    ["Hoary Templar"] = "Weißgrauer Templer",
    ["Earthen Templar"] = "Irdener Templer",
    ["The Duke of Cynders"] = "Der Fürst der Asche",
    ["The Duke of Fathoms"] = "Der Fürst der Tiefen",
    ["The Duke of Zephyrs"] = "Der Fürst der Stürme",
    ["The Duke of Shards"] = "Der Fürst der Splitter",
    ["Aether-tech Assistant"] = "Äthertechnikerassistent",
    ["Aether-tech Adept"] = "Äthertechnikeradept",
    ["Aether-tech Master"] = "Meisteräthertechniker",
	--    ["Trelopades"] = true,
    ["King Dorfbruiser"] = "König Dorfelberster",
    ["Gorgolon the All-seeing"] = "Gorgolon der Allessehende",
	--    ["Matron Li-sahar"] = true,
    ["Solus the Eternal"] = "Solus der Ewige",
	--    ["Balzaphon"] = true,
    ["Lord Blackwood"] = "Fürst Schwarzstahl",
	--    ["Revanchion"] = true,
    ["Scorn"] = "Der Verächter",
    ["Sever"] = "Häcksler",
	--    ["Lady Falther'ess"] = true,
    ["Smokywood Pastures Vendor"] = "Kokelwälder Händler",
	--    ["Shartuul"] = true,
    ["Darkscreecher Akkarai"] = "Dunkelkreischer Akkarai",
	--    ["Karrog"] = true,
    ["Gezzarak the Huntress"] = "Gezzarak die Jägerin",
    ["Vakkiz the Windrager"] = "Vakkiz der Windzürner",
	--    ["Terokk"] = true,
    ["Armbreaker Huffaz"] = "Armbrecher Huffaz",
    ["Fel Tinkerer Zortan"] = "Teufelstüftler Zortan",
	--    ["Forgosh"] = true,
	--    ["Gul'bor"] = true,
    ["Malevus the Mad"] = "Malevus die Verrückte",
    ["Porfus the Gem Gorger"] = "Porfus der Edelsteinschlinger",
    ["Wrathbringer Laz-tarash"] = "Zornschaffer Laz-tarash",
    ["Bash'ir Landing Stasis Chambers"] = "Stasiskammer des Landeplatz von Bash'ir",
    ["Templars"] = "Templer",
    ["Dukes"] = "Fürsten",
	--    ["High Council"] = true,
    ["Headless Horseman"] = "Kopfloser Reiter",
    ["Barleybrew Brewery"] = "Gerstenbräu",
    ["Thunderbrew Brewery"] = "Donnerbräu",
    ["Gordok Brewery"] = "Gordokbrauerei",
    ["Drohn's Distillery"] = "Brauerei Drohn",
    ["T'chali's Voodoo Brewery"] = "T'chalis Voodoobrauerei",
    ["Scarshield Quartermaster"] = "Rüstmeister der Schmetterschilde",
    ["Overmaster Pyron"] = "Übermeister Pyron",
    ["Father Flame"] = "Vater Flamme",
    ["Thomas Yance"] = "Thomas Yance",
    ["Knot Thimblejack"] = "Knot Zwingschraub",
    ["Shen'dralar Provisioner"] = "Versorger der Shen'dralar",
    ["Namdo Bizzfizzle"] = "Namdo Blitzzischel",
    ["The Nameles Prophet"] = "The Nameles Prophet",
    ["Zelemar the Wrathful"] = "Zelemar the Wrathful",
    ["Henry Stern"] = "Henry Stern",
    ["Aggem Thorncurse"] = "Aggem Dornfluch",
    ["Roogug"] = "Roogug",
    ["Rajaxx's Captains"] = "Rajaxx's Captains",
	["Razorfen Spearhide"] = "Speerträger der Klingenhauer",
	["Rethilgore"] = "Rotkralle",
    ["Kalldan Felmoon"] = "Kalldan Teufelsmond",
	["Magregan Deepshadow"] = "Magregan Grubenschatten",
	--  ["Lord Ahune"] = true,
	["Coren Direbrew"] = "Coren Düsterbräu",
    --  ["Don Carlos"] = true,

    --Zones
    ["World Drop"] = "Weltdrops",
	
	--Shortcuts for Bossname files
	--  ["LBRS"] = true,
	--  ["UBRS"] = true,
    ["CoT1"] = "HdZ1",
    ["CoT2"] = "HdZ2",
    --  ["Scholo"] = true,
    --  ["Strat"] = true,
    ["Serpentshrine"] = "Schlangenschrein",

    --Chests, etc
    ["Dark Coffer"] = "Dunkler Kasten",
    ["The Secret Safe"] = "Geheimsafe",
    ["The Vault"] = "Der Tresor",
    ["Ogre Tannin Basket"] = "Gerbekorb der Oger",
    ["Fengus's Chest"] = "Fengus Truhe",
    ["The Prince's Chest"] = "Die Truhe des Prinzen",
    ["Doan's Strongbox"] = "Doans Geldkassette",
    ["Frostwhisper's Embalming Fluid"] = "Frostraunens Balsamierungsflüssigkeit",
    ["Unforged Rune Covered Breastplate"] = "Ungeschmiedete runenverzierte Brustplatte",
    ["Malor's Strongbox"] = "Malors Geldkassette",
    ["Unfinished Painting"] = "Unvollendetes Gemälde",
    ["Felvine Shard"] = "Teufelsrankensplitter",
    ["Baelog's Chest"] = "Baelogs Truhe",
    ["Lorgalis Manuscript"] = "Manuskript von Lorgalis",
    ["Fathom Core"] = "Tiefenkern",
    ["Conspicuous Urn"] = "Verdächtige Urne",
    ["Gift of Adoration"] = "Geschenke der Verehrung",
    ["Box of Chocolates"] = "Schokoladenschachtel",
    ["Treat Bag"] = "Schlotterbeutel",
    ["Gaily Wrapped Present"] = "Fröhlich verpacktes Geschenk",
    ["Festive Gift"] = "Festtagsgeschenk",
    ["Ticking Present"] = "Tickendes Geschenk",
    ["Gently Shaken Gift"] = "Leicht geschütteltes Geschenk",
    ["Carefully Wrapped Present"] = "Sorgfältig verpacktes Geschenk",
    ["Winter Veil Gift"] = "Winterhauchgeschenk",
    ["Smokywood Pastures Extra-Special Gift"] = "Kokelwälder Extraspezialgeschenk",
    ["Brightly Colored Egg"] = "Osterei",
    ["Lunar Festival Fireworks Pack"] = "Feuerwerkspaket des Mondfests",
    ["Lucky Red Envelope"] = "Roter Glücksumschlag",
    ["Small Rocket Recipes"] = "Rezepte für kleine Raketen",
    ["Large Rocket Recipes"] = "Rezepte für große Raketen",
    ["Cluster Rocket Recipes"] = "Rezepte für Raketenbündel",
    ["Large Cluster Rocket Recipes"] = "Rezepte für große Raketenbündel",
	--    ["Timed Reward Chest"] = true,
	--    ["Timed Reward Chest 1"] = true,
	--    ["Timed Reward Chest 2"] = true,
	--    ["Timed Reward Chest 3"] = true,
	--    ["Timed Reward Chest 4"] = true,
    ["The Talon King's Coffer"] = "Der Kasten des Klauenkönigs",
    ["Krom Stoutarm's Chest"] = "Krom Starkarms Truhe",
	["Garrett Family Chest"] = "Familientruhe der Garretts",

    --World Events
    ["Abyssal Council"] = "Abyssischer Rat",
    ["Bash'ir Landing Skyguard Raid"] = "Landeplatz von Bash'ir Himmelswache Raid",
	["Brewfest"] = "Braufest",
    ["Children's Week"] = "Kinderwoche",
    ["Elemental Invasion"] = "Invasion der Elementare",
    ["Ethereum Prison"] = "Gefängnis des Astraleums",
    ["Feast of Winter Veil"] = "Winterhauchfest",
    ["Gurubashi Arena Booty Run"] = "Gurubashiarena",
    ["Hallow's End"] = "Schlotternächte",
    ["Harvest Festival"] = "Erntedankfest",
    ["Love is in the Air"] = "Herzklopfen",
    ["Lunar Festival"] = "Mondfest",
    ["Midsummer Fire Festival"] = "Sonnenwendfest",
    ["Noblegarden"] = "Nobelgarten",
	--    ["Skettis"] = true,
    ["Stranglethorn Fishing Extravaganza"] = "Anglerwettbewerb im Schlingendorntal",

    } end)